<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */

defined( 'ABSPATH' ) || exit;

/**
 * Define constants
 */
define( 'KEYSTONE_THEME_VERSION', '6.1' );
define( 'KEYSTONE_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'KEYSTONE_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
define('BUCKET_API_URL', 'https://bucketserver.com');

/**
 * Includes
 */

// Theme setup
require_once KEYSTONE_THEME_DIR . 'inc/includes/theme-setup.php';

// Theme hooks
require_once KEYSTONE_THEME_DIR . 'inc/includes/theme-hooks.php';

// Framework sync
require_once KEYSTONE_THEME_DIR . 'inc/includes/framework-sync.php';

// Nav Walker
require_once KEYSTONE_THEME_DIR . 'inc/includes/nav-walker.php';

// Widgets
require_once KEYSTONE_THEME_DIR . 'inc/includes/widgets.php';


if ( is_admin() ) {
    // TGM Plugin Activation class
    require_once KEYSTONE_THEME_DIR . 'inc/includes/class-tgm-plugin-activation.php';
    require_once KEYSTONE_THEME_DIR . 'inc/includes/plugin-activation.php';
}

/**
 * Theme helper and common functions
 */

// Helper functions
require_once KEYSTONE_THEME_DIR . 'inc/functions/helper-functions.php';

// Template functions
require_once KEYSTONE_THEME_DIR . 'inc/functions/template-functions.php';
require_once KEYSTONE_THEME_DIR . 'inc/functions/template-extras.php';

/**
 * Template tags
 */
require_once KEYSTONE_THEME_DIR . 'inc/template-tags/breadcrumbs.php';
require_once KEYSTONE_THEME_DIR . 'inc/template-tags/single-comment.php';

/**
 * Plugin compatibility
 */
require_once KEYSTONE_THEME_DIR . 'inc/compatibility/woocommerce.php';

