jQuery(function($) {
    'use strict';
    
    // Move WordPress admin notices into the welcome panel container
    function moveAdminNotices() {
        var $noticeContainer = $('.keystone-admin-notices-container');
        var $adminNotices = $('.wrap > .notice, .wrap > .error, .wrap > .updated, #wpbody-content > .notice, #wpbody-content > .error, #wpbody-content > .updated');
        
        // Move existing notices
        if ($noticeContainer.length && $adminNotices.length) {
            $adminNotices.each(function() {
                var $notice = $(this);
                // Only move if not already inside the container
                if (!$notice.closest('.keystone-admin-notices-container').length) {
                    $noticeContainer.append($notice);
                }
            });
        }
    }
    
    // Move notices on page load
    moveAdminNotices();
    
    // Handle dynamically added notices (e.g., via AJAX)
    $(document).on('wp-updates-notice-added', function() {
        var $noticeContainer = $('.keystone-admin-notices-container');
        var $newNotices = $('.wrap > .notice, .wrap > .error, .wrap > .updated, #wpbody-content > .notice, #wpbody-content > .error, #wpbody-content > .updated').not('.keystone-admin-notices-container .notice, .keystone-admin-notices-container .error, .keystone-admin-notices-container .updated');
        
        if ($noticeContainer.length && $newNotices.length) {
            $newNotices.each(function() {
                var $notice = $(this);
                if (!$notice.closest('.keystone-admin-notices-container').length) {
                    $noticeContainer.append($notice);
                }
            });
        }
    });
    
    // Also check for new notices periodically (for notices added without triggering events)
    setInterval(function() {
        moveAdminNotices();
    }, 500);
});

