<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Automatic Remote API Integration
 * 
 * The easiest way for theme authors! Just set a base URL and the plugin
 * automatically fetches demos based on your theme name.
 * 
 * How it works:
 * 1. Plugin detects your theme name (e.g., "zenix")
 * 2. Constructs API URL: {base_url}/{theme-name}/demos.json
 * 3. Fetches and parses the JSON file
 * 4. Automatically registers all demos found
 * SAFE - Native WordPress hooks are safe (silently ignored if plugin isn't active)
 */
add_filter( 'socs/demo_api_base_url', function() {
	return 'https://bucketserver.com/socs/api';
} );

/**
 * API Key Configuration
 * Add API key for authenticated requests
 */
add_filter( 'socs/demo_api_headers', function( $headers ) {
	$headers['X-API-Key'] = 'bec1e647045610c8ceb58d114f74f1550694aff9575c8e9d5ec40600d877d235';
	return $headers;
} );


/**
 * Modify buttons shown after successful import.
 * SAFE - Native WordPress hooks are safe (silently ignored if plugin isn't active)
 */
// Modify the existing "Visit Site" button

add_filter( 'socs/import_successful_buttons', function( $buttons ) {
	// Modify the existing "Visit Site" button
	foreach ( $buttons as &$button ) {
		if ( isset( $button['id'] ) && $button['id'] === 'visit-site' ) {
			$button['label'] = esc_html__( 'View Site', 'textdomain' );
			$button['href'] = home_url();
			// Add custom CSS class
			$button['class'] = 'socs__gl-item-button button button-primary js-socs-use-predefined-import';
			break;
		}
	}

	// Add another button.
	$buttons[] = array(
		'id'     => 'theme-settings', // This will update the existing button
		'label'  => esc_html__( 'Customize Theme', 'textdomain' ),
		'class'  => 'socs__gl-item-button button button-primary js-socs-use-predefined-import',
		'href'   => admin_url( 'admin.php?page=theme-options' ),
		
	);

	return $buttons;
} );