<?php
add_filter( 'keystone_theme_options', function( $setup ) {

    $fields = array(
        'blog_page_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Blog Page', 'keystone-framework' ),
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'blog_hide_title_bar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Hide Blog Title Bar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to hide the title bar on the main Blog page.', 'keystone-framework' ),
            'value' => false,
            'group' => 'started',
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'blog_subtitle' => array(
            'type' => 'textarea',
            'label' => esc_html__( 'Blog Subtitle', 'keystone-framework' ),
            'description' => esc_html__( 'Enter a subtitle text for the blog page. Visible only on the main blog page configured in Settings > Reading.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'blog_hide_title_bar',
                'value' => 'empty'
            ),
            'group' => 'ended',
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'blog_article_layout' => array(
            'label' => esc_html__( 'Article Layout', 'keystone-framework' ),
            'description' => esc_html__( 'Select the layout for the main blog and archive type pages.', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'blog-layout-classic' => esc_html__( 'Classic', 'keystone-framework' ),
                'blog-layout-horizontal' => esc_html__( 'Horizontal', 'keystone-framework' ),
                'blog-layout-grid' => esc_html__( 'Grid', 'keystone-framework' ),
            ),
            'value' => 'blog-layout-classic',
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'blog_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Blog Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the Main Sidebar on blog and archive pages.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'blog_sidebar_position' => array(
            'label' => esc_html__( 'Sidebar Position', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'sidebar-left' => esc_html__( 'Left', 'keystone-framework' ),
                'sidebar-right' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'sidebar-right',
            'dependency' => array(
                'key' => 'blog_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'blog_sticky_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Sticky Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to keep the sidebar sticky as users scroll.', 'keystone-framework' ),
            'value' => true,
            'dependency' => array(
                'key' => 'blog_sidebar',
                'value' => 'not_empty'
            ),
            'group' => 'ended',
            'submenu' => esc_html__( 'Blog Page', 'keystone-framework' ),
        ),
        'single_post_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Single Post', 'keystone-framework' ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_layout' => array(
            'label' => esc_html__( 'Single Post Layout', 'keystone-framework' ),
            'description' => esc_html__( 'Select the layout for the single blog post pages.', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'blog-single-layout-classic' => esc_html__( 'Classic', 'keystone-framework' ),
                'blog-single-layout-modern' => esc_html__( 'Modern', 'keystone-framework' ),
            ),
            'value' => 'blog-single-layout-classic',
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_modern_bg_color' => array(
            'type' => 'color',
            'label' => esc_html__( 'Modern Layout Background', 'keystone-framework' ),
            'description' => esc_html__( 'Pick a background color for the Modern single post layout container (desktop).', 'keystone-framework' ),
            'value' => '#ffffff',
            'dependency' => array(
                'key' => 'blog_single_layout',
                'value' => 'blog-single-layout-modern'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_hide_featured_image' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Hide Featured Image', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to hide the featured image on single blog post pages.', 'keystone-framework' ),
            'value' => false,
            'dependency' => array(
                'key' => 'blog_single_layout',
                'value' => 'blog-single-layout-classic'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Single Post Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the Main Sidebar on single blog post pages.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_sidebar_position' => array(
            'label' => esc_html__( 'Sidebar Position', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'sidebar-left' => esc_html__( 'Left', 'keystone-framework' ),
                'sidebar-right' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'sidebar-right',
            'dependency' => array(
                'key' => 'blog_single_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_sticky_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Sticky Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to keep the sidebar sticky as users scroll.', 'keystone-framework' ),
            'value' => true,
            'group' => 'ended',
            'dependency' => array(
                'key' => 'blog_single_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_social_share' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Social Sharing Buttons', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display social sharing buttons.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_author' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Author Box', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the author description box.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_pagination' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Previous/Next Pagination', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display previous/next pagination.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_tags' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Post Tags', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display post tags.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_related_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Related Posts', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display related posts.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_related_title' => array(
            'type' => 'text',
            'label' => esc_html__( 'Related Posts Title', 'keystone-framework' ),
            'description' => esc_html__( 'Enter a title for the Related Posts section.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'blog_single_related_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'blog_single_related_number' => array(
            'type' => 'range_slider',
            'label' => esc_html__( 'Number of Related Posts', 'keystone-framework' ),
            'description' => esc_html__( 'Select the number of related posts.', 'keystone-framework' ),
            'min' => 2,
            'max' => 4,
            'step' => 1,
            'value' => 3,
            'dependency' => array(
                'key' => 'blog_single_related_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
            'group' => 'ended',
        ),
        'reading_bar_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Reading Bar', 'keystone-framework' ),
            'value' => true,
            'description' => esc_html__( 'Turn on to display a reading progress indicator. As you read the post or scroll the page, the progress bar is filled with color.', 'keystone-framework' ),
            'group' => 'started',
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'reading_bar_color' => array(
            'type' => 'select',
            'label' => esc_html__( 'Reading Bar Color', 'keystone-framework' ),
            'options' => array(
                'primary-background-color' => esc_html__( 'Primary', 'keystone-framework' ),
                'secondary-background-color' => esc_html__( 'Secondary', 'keystone-framework' ),
                'dark-background-color' => esc_html__( 'Dark', 'keystone-framework' ),
            ),
            'value' => 'primary-background-color',
            'dependency' => array(
                'key' => 'reading_bar_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
        ),
        'reading_bar_height' => array(
            'type' => 'range_slider',
            'label' => esc_html__( 'Reading Bar Height', 'keystone-framework' ),
            'description' => esc_html__( 'Select the height value of the reading bar.', 'keystone-framework' ),
            'min' => 2,
            'max' => 10,
            'step' => 1,
            'value' => 5,
            'dependency' => array(
                'key' => 'reading_bar_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Single Post', 'keystone-framework' ),
            'group' => 'ended',
        ),
        'blog_meta_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Blog Meta', 'keystone-framework' ),
            'description' => esc_html__( 'Control the display of the blog post meta data.', 'keystone-framework' ),
            'submenu' => esc_html__( 'Blog Meta', 'keystone-framework' ),
        ),
        'post_meta_categories' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Post Meta Categories', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Blog Meta', 'keystone-framework' ),
        ),
        'post_meta_date' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Post Meta Date', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Blog Meta', 'keystone-framework' ),
        ),
        'post_meta_author' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Post Meta Author', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Blog Meta', 'keystone-framework' ),
        ),
        'post_meta_comments' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Post Meta Comments', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Blog Meta', 'keystone-framework' ),
        ),
    );

    $customFields = array(
        'name' => esc_html__( 'Blog', 'keystone-framework' ),
        'icon' => 'lnricons-register',
        'fields' => $fields
    );

    $setup[ 'blog' ] = $customFields;

    return $setup;

}, 10, 1 );
