<?php
add_filter( 'keystone_theme_options', function( $setup ) {

    $fields = array(
        'header_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Header', 'keystone-framework' ),
            'submenu' => esc_html__( 'Header', 'keystone-framework' ),
        ),
        'site_header_position' => array(
            'label' => esc_html__( 'Header Position', 'keystone-framework' ),
            'type' => 'radio',
            'description' => esc_html__( 'Select between fixed or sticky header positioning.', 'keystone-framework' ),
            'options' => array(
                'header-position-default' => esc_html__( 'Default', 'keystone-framework' ),
                'sticky-header' => esc_html__( 'Sticky', 'keystone-framework' ),
            ),
            'value' => 'sticky-header',
            'submenu' => esc_html__( 'Header', 'keystone-framework' ),
        ),
        'site_header_scroll_up' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Show on Scroll Up', 'keystone-framework' ),
            'description' => esc_html__( 'Displays the menu only when scrolling up.', 'keystone-framework' ),
            'value' => true,
            'dependency' => array(
                'key' => 'site_header_position',
                'value' => 'sticky-header'
            ),
            'submenu' => esc_html__( 'Header', 'keystone-framework' ),
        ),
        'page_title_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Page Title', 'keystone-framework' ),
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Title Bar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the page title bar.', 'keystone-framework' ),
            'value' => true,
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_text_alignment' => array(
            'label' => esc_html__( 'Text Alignment', 'keystone-framework' ),
            'type' => 'radio',
            'description' => esc_html__( 'Select the text alignment for all elements inside the title bar.', 'keystone-framework' ),
            'options' => array(
                'title-bar-text-left' => esc_html__( 'Left', 'keystone-framework' ),
                'title-bar-text-center' => esc_html__( 'Center', 'keystone-framework' ),
            ),
            'value' => 'title-bar-text-center',
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'group' => 'started',
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_background_color' => array(
            'label' => esc_html__( 'Background Color', 'keystone-framework' ),
            'type' => 'select',
            'description' => esc_html__( 'Select title bar background color.', 'keystone-framework' ),
            'options' => array(
                'default-background-color' => esc_html__( 'Default', 'keystone-framework' ),
                'primary-background-color' => esc_html__( 'Primary', 'keystone-framework' ),
                'secondary-background-color' => esc_html__( 'Secondary', 'keystone-framework' ),
                'white-background-color' => esc_html__( 'White', 'keystone-framework' ),
                'dark-background-color' => esc_html__( 'Dark', 'keystone-framework' ),
                'gray-background-color' => esc_html__( 'Gray', 'keystone-framework' ),
            ),
            'value' => 'default-background-color',
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_text_color' => array(
            'label' => esc_html__( 'Text Color', 'keystone-framework' ),
            'type' => 'select',
            'description' => esc_html__( 'Select title bar text color.', 'keystone-framework' ),
            'options' => array(
                'default-text-color' => esc_html__( 'Default', 'keystone-framework' ),
                'primary-text-color' => esc_html__( 'Primary', 'keystone-framework' ),
                'secondary-text-color' => esc_html__( 'Secondary', 'keystone-framework' ),
                'white-text-color' => esc_html__( 'White', 'keystone-framework' ),
                'dark-text-color' => esc_html__( 'Dark', 'keystone-framework' ),
                'gray-text-color' => esc_html__( 'Gray', 'keystone-framework' ),
            ),
            'value' => 'default-text-color',
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_content_width' => array(
            'type' => 'number',
            'label' => esc_html__( 'Content Width', 'keystone-framework' ),
            'step' => 1,
            'placeholder' => esc_html__('E.g. 600', 'keystone-framework'),
            'description' => esc_html__( 'Control the title bar content width. Pixel value.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_spacing' => array(
            'type' => 'text',
            'label' => esc_html__( 'Top Padding', 'keystone-framework' ),
            'placeholder' => esc_html__('E.g. 100px', 'keystone-framework'),
            'description' => esc_html__( 'Control the title bar top padding. Pixel value.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_spacing_bottom' => array(
            'type' => 'text',
            'label' => esc_html__( 'Bottom Padding', 'keystone-framework' ),
            'placeholder' => esc_html__('E.g. 100px', 'keystone-framework'),
            'description' => esc_html__( 'Control the title bar bottom padding. Pixel value.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'group' => 'ended',
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_breadcrumbs' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Breadcrumbs', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the page breadcrumbs trail.', 'keystone-framework' ),
            'value' => true,
            'dependency' => array(
                'key' => 'title_bar_switch',
                'value' => 'not_empty'
            ),
            'group' => 'started',
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'title_bar_breadcrumbs_position' => array(
            'label' => esc_html__( 'Breadcrumbs Position', 'keystone-framework' ),
            'type' => 'radio',
            'description' => esc_html__( 'Breadcrumbs position relative to the page title.', 'keystone-framework' ),
            'options' => array(
                'breadcrumbs-position-top' => esc_html__( 'Above title', 'keystone-framework' ),
                'breadcrumbs-position-bottom' => esc_html__( 'Below title', 'keystone-framework' ),
            ),
            'value' => 'breadcrumbs-position-bottom',
            'dependency' => array(
                array(
                    'key' => 'title_bar_switch',
                    'value' => 'not_empty'
                ),
                array(
                    'key' => 'title_bar_breadcrumbs',
                    'value' => 'not_empty'
                )
            ),
            'dependencies' => '&&',
            'group' => 'ended',
            'submenu' => esc_html__( 'Page Title', 'keystone-framework' ),
        ),
        'page_layout_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Page Layout', 'keystone-framework' ),
            'submenu' => esc_html__( 'Page Layout', 'keystone-framework' ),
        ),
        'layout_style' => [
            'type' => 'radio',
            'label' => __( 'Page Layout', 'keystone-framework' ),
            'description' => esc_html__( 'Select between full-width or boxed page layout.', 'keystone-framework' ),
            'options' => array(
                'keystone-default' => esc_html__( 'Default', 'keystone-framework' ),
                'keystone-boxed' => esc_html__( 'Boxed', 'keystone-framework' ),
            ),
            'value' => 'keystone-default',
            'submenu' => esc_html__( 'Page Layout', 'keystone-framework' ),
        ],
        'boxed_layout_background_color' => array(
            'label' => esc_html__( 'Body Background Color', 'keystone-framework' ),
            'type' => 'select',
            'description' => esc_html__( 'Select a background color for the page body area.', 'keystone-framework' ),
            'options' => array(
                'keystone-default-bg' => esc_html__( 'Default', 'keystone-framework' ),
                'keystone-primary-bg' => esc_html__( 'Primary', 'keystone-framework' ),
                'keystone-secondary-bg' => esc_html__( 'Secondary', 'keystone-framework' ),
                'keystone-dark-bg' => esc_html__( 'Dark', 'keystone-framework' ),
                'keystone-gray-bg' => esc_html__( 'Gray', 'keystone-framework' ),
            ),
            'value' => 'keystone-default-bg',
            'dependency' => array(
                'key' => 'layout_style',
                'value' => 'keystone-boxed'
            ),
            'submenu' => esc_html__( 'Page Layout', 'keystone-framework' ),
        ),
        'boxed_layout_content_border' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Content Border', 'keystone-framework' ),
            'description' => esc_html__( 'Select a background color for the page content area.', 'keystone-framework' ),
            'value' => false,
            'dependency' => array(
                'key' => 'layout_style',
                'value' => 'keystone-boxed'
            ),
            'submenu' => esc_html__( 'Page Layout', 'keystone-framework' ),
        ),
        'footer_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Footer', 'keystone-framework' ),
            'submenu' => esc_html__( 'Footer', 'keystone-framework' ),
        ),
        'footer_position' => array(
            'label' => esc_html__( 'Footer Position', 'keystone-framework' ),
            'description' => esc_html__( 'The Sticky option creates a smooth overlapping effect with the above section.', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'footer-position-default' => esc_html__( 'Default', 'keystone-framework' ),
                'sticky-footer' => esc_html__( 'Sticky', 'keystone-framework' ),
            ),
            'value' => 'footer-position-default',
            'submenu' => esc_html__( 'Footer', 'keystone-framework' ),
        ),
    );

    $customFields = array(
        'name' => esc_html__( 'Layout', 'keystone-framework' ),
        'icon' => 'lnricons-text-align-center',
        'fields' => $fields
    );

    $setup[ 'layout' ] = $customFields;

    return $setup;

}, 10, 1 );
