<?php
add_filter( 'keystone_theme_options', function( $setup ) {

    $fields = array(
        'maintenance_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Maintenance', 'keystone-framework' ),
            'description' => esc_html__( 'Set your entire website into maintenance mode. The site will be offline until it is ready to be launched.', 'keystone-framework' ),
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Maintenance Mode', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to enable maintenance mode.', 'keystone-framework' ),
            'value' => false,
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_page_title' => array(
            'type' => 'text',
            'label' => esc_html__( 'Page Title', 'keystone-framework' ),
            'description' => esc_html__( 'Enter maintenance page title.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'maintenance_mode_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_page_title_label' => array(
            'type' => 'text',
            'label' => esc_html__( 'Page Title Label', 'keystone-framework' ),
            'description' => esc_html__( 'Enter maintenance page title label.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'maintenance_mode_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_page_content' => array(
            'type' => 'textarea',
            'label' => esc_html__( 'Page Content', 'keystone-framework' ),
            'description' => esc_html__( 'Enter maintenance page description.', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'maintenance_mode_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_image' => array(
            'type' => 'image',
            'label' => esc_html__( 'Page Image', 'keystone-framework' ),
            'dependency' => array(
                'key' => 'maintenance_mode_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_countdown_switch' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Countdown', 'keystone-framework' ),
            'description' => esc_html__( 'Display an estimated completion time.', 'keystone-framework' ),
            'value' => false,
            'dependency' => array(
                'key' => 'maintenance_mode_switch',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_countdown_day' => array(
            'type' => 'text',
            'label' => esc_html__( 'End Day', 'keystone-framework' ),
            'description' => esc_html__( 'Enter day value. Eg. 05', 'keystone-framework' ),
            'dependency' => array(
                array(
                    'key' => 'maintenance_mode_switch',
                    'value' => 'not_empty'
                ),
                array(
                    'key' => 'maintenance_mode_countdown_switch',
                    'value' => 'not_empty'
                )
            ),
            'dependencies' => '&&',
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_countdown_month' => array(
            'type' => 'text',
            'label' => esc_html__( 'End Month', 'keystone-framework' ),
            'description' => esc_html__( 'Enter month value. Eg. 09', 'keystone-framework' ),
            'dependency' => array(
                array(
                    'key' => 'maintenance_mode_switch',
                    'value' => 'not_empty'
                ),
                array(
                    'key' => 'maintenance_mode_countdown_switch',
                    'value' => 'not_empty'
                )
            ),
            'dependencies' => '&&',
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'maintenance_mode_countdown_year' => array(
            'type' => 'text',
            'label' => esc_html__( 'End Year', 'keystone-framework' ),
            'description' => esc_html__( 'Enter year value. Eg. 2024', 'keystone-framework' ),
            'dependency' => array(
                array(
                    'key' => 'maintenance_mode_switch',
                    'value' => 'not_empty'
                ),
                array(
                    'key' => 'maintenance_mode_countdown_switch',
                    'value' => 'not_empty'
                )
            ),
            'dependencies' => '&&',
            'submenu' => esc_html__( 'Maintenance', 'keystone-framework' ),
        ),
        'search_page_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( 'Search Page', 'keystone-framework' ),
            'submenu' => esc_html__( 'Search Page', 'keystone-framework' ),
        ),
        'search_page_title' => array(
            'type' => 'text',
            'label' => esc_html__( 'Page Title', 'keystone-framework' ),
            'description' => esc_html__( 'Enter search page title.', 'keystone-framework' ),
            'submenu' => esc_html__( 'Search Page', 'keystone-framework' ),
        ),
        'search_page_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Display Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to display the Main Sidebar.', 'keystone-framework' ),
            'value' => true,
            'group' => 'started',
            'submenu' => esc_html__( 'Search Page', 'keystone-framework' ),
        ),
        'search_page_sidebar_position' => array(
            'label' => esc_html__( 'Sidebar Position', 'keystone-framework' ),
            'type' => 'radio',
            'options' => array(
                'sidebar-left' => esc_html__( 'Left', 'keystone-framework' ),
                'sidebar-right' => esc_html__( 'Right', 'keystone-framework' ),
            ),
            'value' => 'sidebar-right',
            'dependency' => array(
                'key' => 'search_page_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Search Page', 'keystone-framework' ),
        ),
        'search_page_sticky_sidebar' => array(
            'type' => 'checkbox',
            'label' => esc_html__( 'Sticky Sidebar', 'keystone-framework' ),
            'description' => esc_html__( 'Turn on to keep the sidebar sticky as users scroll.', 'keystone-framework' ),
            'value' => true,
            'group' => 'ended',
            'dependency' => array(
                'key' => 'search_page_sidebar',
                'value' => 'not_empty'
            ),
            'submenu' => esc_html__( 'Search Page', 'keystone-framework' ),
        ),
        'error_page_tab_label' => array(
            'type' => 'group_title',
            'label' => esc_html__( '404 Page', 'keystone-framework' ),
            'submenu' => esc_html__( '404 Page', 'keystone-framework' ),
        ),
        'error_page_title' => array(
            'type' => 'text',
            'label' => esc_html__( 'Page Title', 'keystone-framework' ),
            'description' => esc_html__( 'Enter 404 page title.', 'keystone-framework' ),
            'submenu' => esc_html__( '404 Page', 'keystone-framework' ),
        ),
        'error_page_subtitle' => array(
            'type' => 'text',
            'label' => esc_html__( 'Page Subtitle', 'keystone-framework' ),
            'description' => esc_html__( 'Enter 404 page subtitle.', 'keystone-framework' ),
            'submenu' => esc_html__( '404 Page', 'keystone-framework' ),
        ),
    );

    $customFields = array(
        'name' => esc_html__( 'Utility Pages', 'keystone-framework' ),
        'icon' => 'lnricons-wrench',
        'fields' => $fields
    );

    $setup[ 'utility-pages' ] = $customFields;

    return $setup;

}, 10, 1 );
