<?php
namespace KeyStone;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


use KeyStone\Utils;

$theme_name = Utils::get_parent_theme_name();
$license_key = License\Admin::get_license_key();
$update_data = License\API::check_update( false /* Use Cache */ );
$theme_version = Utils::get_parent_theme_version();
$license_key = License\Admin::get_license_key();

// Load Welcome Panel template
require_once KEYSTONE_PATH . 'includes/admin/views/welcome-panel.php';
?>
<div class="ksadmin-dashboard">
	<div class="ksadmin-welcome-box">
		<div class="ksadmin-column-container">
		<div class="keystone-welcome-panel">
		<div class="keystone-welcome-panel-header">
        <div class="keystone-welcome-panel-column-container">
            <div class="keystone-welcome-panel-column">
				<div class="keystone-welcome-headline">
                <h1 class="welcome-panel-title"><?php printf( esc_html__( 'Welcome to %1$s', 'keystone-framework' ), esc_html( Utils::get_parent_theme_name() ) ); ?></h1>
				<p class="keystone-theme-version"><?php printf( esc_html__( 'Version: %s', 'keystone-framework' ), esc_html( $theme_version ) ); ?></p> </div>
                <?php if ( empty( $license_key ) ) : ?>
                    <?php if ( keystone_theme_requires_license() ) : ?>
					<p class="welcome-panel-description">
						<?php printf(
							esc_html__( '%1$s theme has been installed and is ready to use. Register your purchase to unlock demo sites, the Elementor template library, and automatic updates.', 'keystone-framework' ),
							esc_html( $theme_name )
						); ?>
					</p>
				<?php else : ?>
					<p class="welcome-panel-description">
						<?php printf(
							esc_html__( '%1$s theme is fully unlocked. You can now access demo sites, the Elementor template library, However the purchase code is required for auto updates and 6 month support from Keystone Themes.', 'keystone-framework' ),
							esc_html( $theme_name )
						); ?>
					</p>
				<?php endif; ?>
                <?php else : ?>
                    <p class="welcome-panel-description"><?php printf( esc_html__( '%1$s theme has been successfully registered and is ready to use. Enjoy seamless customization and effortlessly create a professional-looking website.', 'keystone-framework' ), esc_html( $theme_name ) ); ?></p>
                <?php endif; ?>
            </div>
       			 </div>
    		</div>
			</div>
			<h2 class="first-title"><?php esc_html_e( 'Theme Registration', 'keystone-framework' ); ?></h2>
			<?php require_once KEYSTONE_PATH . 'includes/admin/views/deactivate-notice.php'; ?>
			<div class="ksadmin-activate-wrapper">
				<?php
					// Load Activation Box template
					require_once KEYSTONE_PATH . 'includes/admin/views/activation-box.php';
				?>
				<?php
					// Load Update Box template
					require_once KEYSTONE_PATH . 'includes/admin/views/update-box.php';
				?>
				<?php
				 	// Load Support Box template
					require_once KEYSTONE_PATH . 'includes/admin/views/support-box.php';
				?>
				
			</div>
			<div class="ksadmin-column-container">
				<h2><?php esc_html_e( 'Help & Support', 'keystone-framework' ); ?></h2>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-book2"></span><?php esc_html_e( 'View Documentation', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Helpful information about theme setup, capabilities, features and options.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-button" href="https://help.keystonethemes.com/" target="_blank"><?php esc_html_e( 'Read documentation', 'keystone-framework' ); ?></a>
				</div>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-lifebuoy"></span><?php esc_html_e( 'Support Center', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Got a question or need help with the theme? You can always submit a support ticket.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-button" href="https://keystonethemes.authordesk.app/login" target="_blank"><?php esc_html_e( 'Submit a ticket', 'keystone-framework' ); ?></a>
				</div>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-users"></span><?php esc_html_e( 'Web Development', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Get a high-performance, secure, and stunning website—built by experts.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-button" href="https://keystonethemes.com/web-development/" target="_blank"><?php esc_html_e( 'Get Now', 'keystone-framework' ); ?></a>
				</div>

			</div>
	        <div class="ksadmin-column-container">
				<h2><?php esc_html_e( 'Insights', 'keystone-framework' ); ?></h2>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-store"></span><?php esc_html_e( 'Check Our Latest Themes', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Discover a curated selection of premium WordPress themes.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-button" href="https://keystonethemes.com/themes/" target="_blank"><?php esc_html_e( 'Shop Themes', 'keystone-framework' ); ?></a>
					<span class="support-badge active"><?php echo esc_html__( 'Hot', 'keystone-framework' ); ?></span>

				</div>
				<?php if ( $license_key && $update_data[ 'status' ] ) : ?>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-history"></span><?php printf( esc_html__( 'What\'s new on version %1$s', 'keystone-framework' ), esc_html( $update_data['version'] ) ); ?></h3>
					<p><?php esc_html_e( 'View features, bug fixes or any other changes in the latest theme version.', 'keystone-framework' ); ?></p>
					<?php add_thickbox(); ?>
					<div id="keystone-changelog-modal" style="display:none;">
						<?php echo wp_kses_post( $update_data['changelog'] ); ?>
					</div>
					<a title="<?php printf( esc_attr__( 'What\'s new on version %1$s', 'keystone-framework' ), esc_attr( $update_data['version'] ) ); ?>" class="ksadmin-button thickbox" href="#TB_inline?&width=720&height=550&inlineId=keystone-changelog-modal"><?php esc_html_e( 'View changelog', 'keystone-framework' ); ?></a>
				</div>
				<?php endif; ?>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-envelope"></span><?php esc_html_e( 'Subscribe', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Subscribe to our newsletter to get notified for theme sales and promotional offers.', 'keystone-framework' ); ?></p>

					<!-- Begin Mailchimp Signup Form -->
					<div id="mc_embed_signup">
						<form action="https://keystonethemes.us18.list-manage.com/subscribe/post?u=c620a0a281cfda2047a884ddc&amp;id=cace639e76&amp;f_id=009cc2e1f0" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>
							<div id="mc_embed_signup_scroll">
						<div class="mc-field-group">
						<input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL" placeholder="Email Address">
						<span id="mce-EMAIL-HELPERTEXT" class="helper_text"></span>
					</div>
						<div id="mce-responses" class="clear">
							<div class="response" id="mce-error-response" style="display:none"></div>
							<div class="response" id="mce-success-response" style="display:none"></div>
						</div>
						<div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_c620a0a281cfda2047a884ddc_cace639e76" tabindex="-1" value=""></div>
						<div class="clear"><input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe" class="button"></div>
						</div>
					</form>
					</div>
					<script type='text/javascript' src='//s3.amazonaws.com/downloads.mailchimp.com/js/mc-validate.js'></script><script type='text/javascript'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]='EMAIL';ftypes[0]='email';fnames[1]='FNAME';ftypes[1]='text';fnames[2]='LNAME';ftypes[2]='text';fnames[3]='ADDRESS';ftypes[3]='address';fnames[4]='PHONE';ftypes[4]='phone';fnames[5]='BIRTHDAY';ftypes[5]='birthday';}(jQuery));var $mcj = jQuery.noConflict(true);</script>
					<!--End mc_embed_signup-->
				</div>


				</div>
						</div>

		</div>
	</div>

</div>