<?php
/**
 * Demo Import Page.
 *
 * @package SigmaDevs\EasyDemoImporter
 */

require_once KEYSTONE_PATH . 'includes/admin/views/welcome-panel.php';

$license_status = \KeyStone\License\Admin::get_license_key();

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

if ( ! $license_status && keystone_theme_requires_license() ) {
	require_once KEYSTONE_PATH . 'includes/admin/views/register-notice.php';
} else {
	?>
	<div class="ksadmin-dashboard ksadmin-import">
		<div class="ksadmin-welcome-box postbox">
			<div class="ksadmin-intro-text">
				<h2><?php echo esc_html__( 'Import a Starter Site', 'keystone-framework' ); ?></h2>
				<p><?php echo esc_html__( 'Import any of the starter sites below. We recommend using this feature for fresh installations.', 'keystone-framework' ); ?></p>
				<p><?php echo wp_kses_post( sprintf( __( 'Please check the %1$s page to verify that your server meets all the requirements for a successful import.', 'keystone-framework' ),
						'<a href="' . esc_url( admin_url( 'admin.php?page=keystone-system-status' ) ) . '">' . esc_html__( 'System Info', 'keystone-framework' ) . '</a>'
					) ); ?></p>
			</div>
			<div class="keystone-notice keystone-import-notice">
				<p><strong><?php esc_html_e( 'Important Note:', 'keystone-framework' ); ?></strong> <?php esc_html_e( 'Importing a demo site will replace the colors and fonts in your Elementor Site Settings panel.', 'keystone-framework' ); ?></p>
			</div>
		</div>
	
	<?php // With custom options
		socs_display_smart_import( array(
			'wrapper_class'          => 'my-custom-class',  // Custom CSS class for wrapper
			'show_header'             => false,  // Hide plugin header
			'show_sidebar'            => false,  // Hide theme card sidebar
			'load_plugin_css'         => true,  // Use theme styles
			'show_smart_import_tabs'  => false,  // Hide the tabs
			'show_file_upload_header' => false,  // Hide the file upload header
			'show_intro_text'         => false,  // Hide the intro text
		) );
 	?>
	</div>
	<?php
}
?>


