<?php
namespace KeyStone;
use KeyStone\Utils;

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

require_once KEYSTONE_PATH . 'includes/admin/views/welcome-panel.php'; ?>
<div class="ksadmin-dashboard ksadmin-help">
  <div class="ksadmin-docs-wrapper">
    <div class="ksadmin-welcome-box postbox">
      <div class="ksadmin-intro-text">
        <h2><?php echo esc_html__( 'Documentation', 'keystone-framework' ); ?></h2>
        <p><?php echo wp_kses_post( sprintf( __( 'Choose the help section you want to explore or read the complete %s.', 'keystone-framework' ), '<a href="https://help.keystonethemes.com/docs/theme-documentation" target="_blank">' . esc_html__( 'documentation', 'keystone-framework' ) . '</a>' ) ); ?></p>
      </div>
    </div>
    </div>
    </div>

<div class="ksadmin-dashboard ksadmin-help">
  <div class="ksadmin-docs-wrapper">
    <div class="ksadmin-documentation">
      
      <ul>
				<div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-home"></span><?php esc_html_e( 'General', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Overview of the theme’s features, settings, and basic setup instructions.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-docs-button" href="https://help.keystonethemes.com/general/" target="_blank"><?php esc_html_e( 'View docs', 'keystone-framework' ); ?></a>
				</div>
        <div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-rocket"></span><?php esc_html_e( 'Getting started', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'A guide to help you set up and configure the theme for the first time.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-docs-button" href="https://help.keystonethemes.com/getting-started/" target="_blank"><?php esc_html_e( 'View docs', 'keystone-framework' ); ?></a>
				</div>
        <div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-desktop"></span><?php esc_html_e( 'Site setup', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Instructions for configuring your website and installing the theme.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-docs-button" href="https://help.keystonethemes.com/site-setup/" target="_blank"><?php esc_html_e( 'View docs', 'keystone-framework' ); ?></a>
				</div>
        <div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-question"></span><?php esc_html_e( 'How to', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Step-by-step instructions for performing specific tasks or configuring features.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-docs-button" href="https://help.keystonethemes.com/how-to/" target="_blank"><?php esc_html_e( 'View docs', 'keystone-framework' ); ?></a>
				</div>
        <div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-wrench"></span><?php esc_html_e( 'Troubleshooting', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Solutions to common issues and errors you may encounter while using the theme.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-docs-button" href="https://help.keystonethemes.com/troubleshooting/" target="_blank"><?php esc_html_e( 'View docs', 'keystone-framework' ); ?></a>
				</div>
        <div class="ksadmin-panel-column">
					<h3><span class="dashboard-icon lnricons-user"></span><?php esc_html_e( 'Developer', 'keystone-framework' ); ?></h3>
					<p><?php esc_html_e( 'Information and guidelines for developers to customize, extend, and integrate.', 'keystone-framework' ); ?></p>
					<a class="ksadmin-docs-button" href="https://help.keystonethemes.com/developer/" target="_blank"><?php esc_html_e( 'View docs', 'keystone-framework' ); ?></a>
				</div>
      </ul>
    </div>
  </div>
  	<div class="ksadmin-support-box">
  	
    <div class="ksadmin-support-info">
      <h2><?php echo esc_html__( 'Customer Support', 'keystone-framework' ); ?></h2>
	    <p><?php echo wp_kses_post( sprintf( __( 'You can ask questions about the theme\'s features or report bugs. To get help, go to our %s and submit a ticket.', 'keystone-framework' ), '<a href="https://keystonethemes.authordesk.app/login" target="_blank">' . esc_html__( 'support center', 'keystone-framework' ) . '</a>' ) ); ?></p>
      <h3><?php echo esc_html__( 'Our support includes the following:', 'keystone-framework' ); ?></h3>
      <ul>
        <li><span><i class="lnricons-checkmark-circle"></i><?php echo esc_html__( 'Answering any questions about theme functionality and technical capabilities.', 'keystone-framework' ); ?></span></li>
        <li><span><i class="lnricons-checkmark-circle"></i><?php echo esc_html__( 'Helping with setting up the features included in our themes and configuring theme settings', 'keystone-framework' ); ?></span></li>
        <li><span><i class="lnricons-checkmark-circle"></i><?php echo esc_html__( 'Fixing bugs or resolving issues', 'keystone-framework' ); ?></span></li>
      </ul>
      <h3><?php echo esc_html__( 'Our support does not cover:', 'keystone-framework' ); ?></h3>
      <ul>
        <li><span><i class="lnricons-cross-circle"></i><?php echo esc_html__( 'Custom code or code modifications.', 'keystone-framework' ); ?></span></li>
        <li><span><i class="lnricons-cross-circle"></i><?php echo esc_html__( 'Adding new functionality or third-party plugins.', 'keystone-framework' ); ?></span></li>
      </ul>
    </div>
  </div>
</div>