<?php
namespace KeyStone;

use KeyStone\Admin\System_Status;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

System_Status::init_vars();

require_once KEYSTONE_PATH . 'includes/admin/views/welcome-panel.php'; ?>

<div class="keystone-system-status">

    <table class="keystone-system-status-theme-info widefat">
        <thead>
        <tr>
            <th colspan="3"><?php esc_html_e( 'Theme information', 'keystone-framework' ); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td><?php esc_html_e( 'Name:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The name of the current active theme.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'theme_name' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'Version:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The installed version of the current active theme.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_theme_version(); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'Child theme:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'Is the child theme in use?', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::yes_null( System_Status::get_var( 'is_child_theme' ) ) ); ?></th>
        </tr>
		<tr>
            <td><?php esc_html_e( 'Connection to Keystone API:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'Returns connection status with Keystone API server.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_api_connection_status(); ?></th>
        </tr>
        </tbody>
    </table>

    <table class="keystone-system-status-wordpress widefat">
        <thead>
        <tr>
            <th colspan="3"><?php esc_html_e( 'WordPress environment', 'keystone-framework' ); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td><?php esc_html_e( 'WordPress address (URL):', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The URL of your site\'s homepage.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_url( System_Status::get_var( 'wp_home_url' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'Site address (URL):', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The root URL of your WordPress installation.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_url( System_Status::get_var( 'wp_site_url' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'WordPress path:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'System path of your WordPress root directory.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'wp_abspath' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'WordPress content path:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'System path of your wp-content directory.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'wp_content_dir' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'WordPress version:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The version of WordPress installed on your site.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_wp_version(); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'WordPress multisite:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'Whether or not you have WordPress Multisite enabled.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::yes_null( System_Status::get_var( 'wp_multisite' ) ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'WordPress memory limit:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The maximum amount of memory (RAM) that your site can use at one time.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_memory_limit(); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'WordPress debug mode:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'Displays whether or not WordPress is in Debug Mode.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::yes_null( System_Status::get_var( 'wp_debug' ) ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'Language:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The current language used by WordPress.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'wp_language' ) ); ?></th>
        </tr>
        </tbody>
    </table>

    <table class="keystone-system-status-server widefat">
        <thead>
        <tr>
            <th colspan="3"><?php esc_html_e( 'Server environment', 'keystone-framework' ); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td><?php esc_html_e( 'Server info:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'Information about the web server that is currently hosting your site.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'server_info' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'PHP version:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The version of PHP installed on your hosting server.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_php_version(); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'PHP post max size:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The largest filesize that can be contained in one post.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( size_format( System_Status::get_var( 'php_post_max_size' ) ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'PHP time limit:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The amount of time (in seconds) that your site will spend on a single operation before timing out (to avoid server lockups).', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_php_max_execution_time() ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'PHP max input vars:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The maximum number of variables your server can use for a single function to avoid overloads.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::display_php_max_input_vars() ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'Max upload size:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The largest filesize that can be uploaded to your WordPress installation.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( size_format( System_Status::get_var( 'max_upload_size' ) ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'MySQL version:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The version of MySQL installed on your hosting server.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'mysql_version' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'cURL version:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'The version of cURL installed on your hosting server.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::get_var( 'curl_version' ) ); ?></th>
        </tr>
        <tr>
            <td><?php esc_html_e( 'DOMDocument:', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'DOMDocument is required for the theme Demo Import feature to properly function.', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php echo esc_html( System_Status::yes_no( System_Status::get_var( 'domdocument' ) ) ); ?></th>
        </tr>
		<tr>
            <td><?php esc_html_e( 'Secure connection (HTTPS):', 'keystone-framework' ); ?></td>
            <td class="help">
                <i class="dashicons dashicons-info" title="<?php esc_attr_e( 'Is the connection to your website secure?', 'keystone-framework' ); ?>"></i>
            </td>
            <th><?php System_Status::display_secure_connection(); ?></th>
        </tr>
        </tbody>
    </table>
</div>
