<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Image widget
function keystone_image_widget_controls( $element ) {
    // Add pointer events control
    $element->add_control(
        'keystone_image_pointer_events',
        [
            'label' => esc_html__( 'Pointer events', 'keystone-framework' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'all' => esc_html__( 'All', 'keystone-framework' ),
                'none' => esc_html__( 'None', 'keystone-framework' ),
            ],
            'default' => 'all',
            'selectors' => [
                '{{WRAPPER}} img' => 'pointer-events: {{VALUE}};',
            ],
        ]
    );
}
add_action( 'elementor/element/image/section_image/before_section_end', 'keystone_image_widget_controls' );

// Icon List widget
function keystone_icon_list_widget_controls( $element ) {
    $element->update_control(
		'text_color_hover',
		[
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-text' => 'color: {{VALUE}};',
				'.underline-link-effect {{WRAPPER}} .elementor-icon-list-item:hover .elementor-icon-list-text:after' => 'background-color: {{VALUE}};',
			],
		]
	);
}
add_action( 'elementor/element/icon-list/section_text_style/before_section_end', 'keystone_icon_list_widget_controls' );

