<?php
use KeyStone\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$wrapper_class      = '';
$style_class        = '';
$backtotop_progress = false;

// Wrapper class.
$position       = Utils::get_option( 'go_top_button_position' );
$color_scheme   = Utils::get_option( 'go_top_button_color' );
$backtotop_style = Utils::get_option( 'go_top_button_style' );

if ( 'scroll-progress-style' === $backtotop_style ) {
    $backtotop_progress = true;
    $style_class        = 'scroll-position-style';
}

$classes = array( 'back-to-top' );

if ( ! empty( $position ) ) {
    $classes[] = $position;
}

// For the custom color option we rely on dynamic CSS instead of a predefined color scheme class.
if ( ! empty( $color_scheme ) && 'custom-color' !== $color_scheme ) {
    $classes[] = $color_scheme;
}

if ( ! empty( $style_class ) ) {
    $classes[] = $style_class;
}

$wrapper_class = implode( ' ', $classes );

?>
<div class="<?php echo esc_attr( trim( $wrapper_class ) ); ?>">
    <span class="icon-arrow-up"></span>
    <?php if ( $backtotop_progress == true ) : ?>
        <svg height="50" width="50"><circle cx="25" cy="25" r="24" /></svg>
    <?php endif; ?>
</div>
