<?php
/**
 * Plugin Name: Keystone Framework
 * Description: Keystone Themes core plugin.
 * Version: 12.6
 * Author: Keystone Themes
 * Author URI: https://keystonethemes.com/
 * Text Domain: keystone-framework
 * Domain Path: /languages/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Set constants.
 */
define( 'KEYSTONE_VERSION', '12.6' );

define( 'KEYSTONE_FILE', __FILE__ );
define( 'KEYSTONE_PLUGIN_BASE', plugin_basename( KEYSTONE_FILE ) );
define( 'KEYSTONE_PATH', plugin_dir_path( KEYSTONE_FILE ) );
define( 'KEYSTONE_URL', plugin_dir_url( KEYSTONE_FILE ) );

define( 'KEYSTONE_COMPATIBILITY_PATH', KEYSTONE_PATH . 'includes/compatibility' );
define( 'KEYSTONE_MODULES_PATH', KEYSTONE_PATH . 'includes/modules' );
define( 'KEYSTONE_ASSETS_PATH', KEYSTONE_PATH . 'assets/' );
define( 'KEYSTONE_ASSETS_URL', KEYSTONE_URL . 'assets/' );

add_action( 'plugins_loaded', 'keystone_load_plugin_textdomain' );

/**
 * ============================================================
 *  Keystone & Bucket Server Configuration
 * ============================================================
 */

// Main bucket-manager server URL
if ( ! defined( 'BUCKETAPI_URL' ) ) {
    define( 'BUCKETAPI_URL', 'https://bucketserver.com' );
}

// Elementor Library API base URL
if ( ! defined( 'BUCKET_LIBRARY_URL' ) ) {
    define( 'BUCKET_LIBRARY_URL', 'https://bucketserver.com' );
}

// API connection
define( 'KEYSTONE_API_URL', BUCKETAPI_URL . '/manage/' );


/** Load extras **/
require_once plugin_dir_path(__FILE__) . 'includes/admin/lib/extra/extra.php'; 

/** Load extras **/

/**
 * Load KeyStone textdomain.
 *
 * Load gettext translate for KeyStone text domain.
 *
 * @return void
 */
function keystone_load_plugin_textdomain() {
	load_plugin_textdomain( 'keystone-framework', false, dirname( KEYSTONE_PLUGIN_BASE ) . '/languages' );
}

function is_keystone_theme() {
	$author_name = 'Keystone-Themes';

	$theme = wp_get_theme( get_template() );
	if ( ! $theme->parent() ) {
		$theme_author = $theme->get( 'Author' );
	} else {
		$theme_author = $theme->parent( 'Author' );
	}

	if ( $author_name == $theme_author ) {
		return true;
	}

	return false;
}

/* Allow SVG upload */
add_filter( 'wp_check_filetype_and_ext', function( $data, $file, $filename, $mimes ) {

  $filetype = wp_check_filetype( $filename, $mimes );

  return [
      'ext' => $filetype['ext'],
      'type' => $filetype['type'],
      'proper_filename' => $data['proper_filename']
  ];

}, 10, 4 );

function allow_svg_upload( $mimes ) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svg+xml';
  return $mimes;
}
add_filter( 'upload_mimes', 'allow_svg_upload' );

if ( ! version_compare( PHP_VERSION, '7.0', '>=' ) ) {
    add_action( 'admin_notices', 'keystone_fail_php_version' );
} elseif ( ! version_compare( get_bloginfo( 'version' ), '6.0', '>=' ) ) {
    add_action( 'admin_notices', 'keystone_fail_wp_version' );
} else {
	if ( is_keystone_theme() ) {
    	require KEYSTONE_PATH . 'includes/plugin.php';
	}
}

function keystone_fail_php_version() {
	$message = sprintf(
		esc_html__( 'Keystone Framework isn’t running because PHP is outdated. Update to PHP version %1$s.', 'keystone-framework' ),
		'7.0',
	);
	$html_message = sprintf( '<div class="error">%s</div>', wpautop( $message ) );
	echo wp_kses_post( $html_message );
}

function keystone_fail_wp_version() {
	$message = sprintf(
		esc_html__( 'Keystone Framework isn’t running because WordPress is outdated. Update to version %1$s.', 'keystone-framework' ),
		'5.9',
	);
	$html_message = sprintf( '<div class="error">%s</div>', wpautop( $message ) );
	echo wp_kses_post( $html_message );
}

// Add at the bottom of your main plugin file (e.g., keystone-framework.php or similar).
add_action( 'init', 'keystone_force_refresh_transients_for_testing' );

function keystone_force_refresh_transients_for_testing() {
    delete_transient( 'keystone_license_rules' );
    delete_transient( 'remote_insta_notice_data' );

    add_filter( 'pre_transient_keystone_license_rules', function() {
        return false;
    });

    add_filter( 'pre_transient_remote_insta_notice_data', function() {
        return false;
    });
}


