# Keystone Framework

**Version:** 12.6  
**Author:** Keystone Themes  
**Author URI:** https://keystonethemes.com/  
**License:** GPL v2 or later  
**License URI:** https://www.gnu.org/licenses/gpl-2.0.html

## Description

Keystone Framework is the core plugin for Keystone Themes, providing essential functionality, theme options, demo import capabilities, and Elementor integration for premium WordPress themes.

## Features

- **Theme Options Panel** - Comprehensive theme customization options
- **Demo Import** - One-click demo content installation
- **Elementor Integration** - Enhanced Elementor Site Settings, template library, and kit management
  - One-click Elementor Site Kit activation from library listing
  - Visual kit status indicators
- **Portfolio Module** - Custom post type with advanced filtering
- **Maintenance Mode** - Customizable maintenance page
- **Performance Optimization** - Built-in caching and optimization features
- **Social Sharing** - Integrated social media sharing buttons
- **Widget Library** - Custom WordPress widgets
- **System Status** - Server and WordPress environment checker

## Installation

1. Upload the `keystone-framework` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Navigate to the Keystone Dashboard to configure settings
4. Register your license key to unlock premium features

## Requirements

- **WordPress Version:** 6.0 or higher
- **PHP Version:** 7.0 or higher (7.4+ recommended)
- **Recommended PHP Memory Limit:** 256MB
- **Recommended PHP Max Execution Time:** 90 seconds
- **Recommended PHP Max Input Vars:** 2500

## Changelog

### Version 12.6 - 2025-11-23

#### New Features
* **WordPress Admin Notices Container** - Added admin notices container in welcome panel
  - WordPress admin notices now display in the welcome panel instead of at the top of pages
  - Improved user experience with centralized notice display
  - Automatic notice relocation using JavaScript
  - Supports dynamically added notices via AJAX

#### Improvements
* Updated plugin version to 12.6
* Added `.gitignore` file to exclude unnecessary files
* Code cleanup and organization

### Version 12.3 - 2025-10-27

#### New Features
* **Plugin Details Modal** - Added "View details" link on WordPress Plugins page
  - Click "View details" to view complete plugin information in a modal
  - Displays full readme.md content with proper formatting
  - Beautiful, responsive modal design with smooth animations
  - Markdown to HTML conversion for better readability
  - Easy access to changelog, features, and documentation
  - Close modal with X button, overlay click, or ESC key
  
* **Elementor Kit Activation Button** - Added "Kit Status" column to Elementor Library listing page
  - Display active/inactive status for all Elementor Site Kits
  - One-click kit activation directly from the library listing
  - Visual indicator showing which kit is currently active
  - Secure nonce verification for kit activation
  - Automatic Elementor cache clearing after activation
  - User capability checks to ensure only authorized users can activate kits
  - Success notification after successful kit activation

#### Security Enhancements
* **Major Security Update:** Implemented comprehensive output escaping throughout the entire plugin
* Fixed all unescaped output vulnerabilities to prevent XSS (Cross-Site Scripting) attacks
* All output now properly sanitized using WordPress escaping functions

#### Fixed Files:
* `keystone-framework.php` - Sanitized `$_GET` parameters and inline CSS output
* `includes/admin/lib/nuxy/settings/view/main.php` - Escaped JSON output using `wp_json_encode()`
* `includes/admin/views/system-status-view.php` - Added `esc_html()` to all system information outputs
* `includes/admin/views/dashboard-view.php` - Properly escaped changelog content with `wp_kses_post()`
* `includes/admin/views/demo-import-view.php` - Escaped sprintf output with HTML
* `includes/admin/views/help-view.php` - Used `wp_kses_post()` for documentation links
* `includes/admin/views/update-box.php` - Escaped version numbers
* `includes/admin/views/activation-box.php` - Escaped theme name variables
* `includes/admin/views/register-notice.php` - Fixed `esc_html_e()` usage
* `includes/admin/views/site-settings-notice.php` - Properly escaped HTML output
* `includes/admin/system-status.php` - Escaped all system status display outputs
* `includes/widgets/recent-posts/widget.php` - Replaced `_e()` with `esc_html_e()`, escaped all widget outputs
* `includes/modules/portfolio/template-parts/category.php` - Escaped term names and URLs
* `includes/modules/portfolio/template-parts/navigation.php` - Escaped portfolio navigation links
* `includes/modules/portfolio/template-parts/related.php` - Fixed translation function usage
* `includes/theme-features.php` - Escaped reading bar color classes
* `includes/theme-features/social-sharing.php` - Fixed social sharing title attributes
* `includes/compatibility/elementor.php` - Sanitized `$_GET` and `$_SERVER` variables

#### Escaping Functions Implemented:
* `esc_html()` - For HTML content
* `esc_html_e()` - For translated HTML content
* `esc_html__()` - For translated HTML strings
* `esc_attr()` - For HTML attributes
* `esc_attr_e()` - For translated attributes
* `esc_attr__()` - For translated attribute strings
* `esc_url()` - For URLs
* `wp_kses_post()` - For content with allowed HTML tags
* `wp_json_encode()` - For safe JSON encoding
* `sanitize_text_field()` - For text input sanitization
* `wp_unslash()` - For removing slashes from data

#### Code Quality:
* All code now complies with WordPress Coding Standards for output escaping
* Improved security posture across all admin panels and frontend features
* Enhanced input validation and sanitization

### Version 12.2 - Previous Release

* Previous version features and fixes

## Security

This plugin follows WordPress security best practices:
- All user input is sanitized
- All output is escaped
- Nonce verification on form submissions
- Capability checks for admin functions
- SQL queries use prepared statements
- File upload restrictions in place

## Support

For support, documentation, and feature requests:
- **Documentation:** https://help.keystonethemes.com/
- **Support Center:** https://keystonethemes.authordesk.app/login
- **Website:** https://keystonethemes.com/

## Development

### Development Team
Developed and maintained by Keystone Themes

### Coding Standards
This plugin adheres to:
- WordPress Coding Standards
- WordPress Security Best Practices
- PHP 7.0+ compatibility requirements

## License

This plugin is licensed under the GPL v2 or later.

```
Copyright (C) 2025 Keystone Themes

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
```

